VERSION 5.00
Begin VB.Form LinkForm 
   BorderStyle     =   1  'Fixed Single
   Caption         =   " "
   ClientHeight    =   4245
   ClientLeft      =   45
   ClientTop       =   330
   ClientWidth     =   6675
   ControlBox      =   0   'False
   LinkTopic       =   "Form1"
   LockControls    =   -1  'True
   MaxButton       =   0   'False
   MinButton       =   0   'False
   ScaleHeight     =   4245
   ScaleWidth      =   6675
   StartUpPosition =   2  'CenterScreen
   Begin VB.Frame lbl_CNT 
      Caption         =   "#Contacts"
      Height          =   1935
      Left            =   0
      TabIndex        =   0
      Top             =   2280
      Width           =   6615
      Begin Project1.ArmCheckView0 ckv_contact 
         Height          =   1575
         Left            =   120
         TabIndex        =   1
         Top             =   240
         Width           =   6375
         _ExtentX        =   11245
         _ExtentY        =   2778
      End
   End
   Begin Project1.ArmCombobox cbo_role 
      Height          =   345
      Left            =   2400
      TabIndex        =   2
      Top             =   1800
      Width           =   4215
      _ExtentX        =   7435
      _ExtentY        =   609
   End
   Begin Project1.A_Seek seek_Cust 
      Height          =   375
      Left            =   2400
      TabIndex        =   3
      Top             =   1320
      Width           =   4215
      _ExtentX        =   5953
      _ExtentY        =   661
   End
   Begin Project1.A_Seek seek_Proj 
      Height          =   375
      Left            =   2400
      TabIndex        =   4
      Top             =   840
      Width           =   4215
      _ExtentX        =   5953
      _ExtentY        =   661
   End
   Begin Project1.ToolBr tb_top 
      Align           =   1  'Align Top
      Height          =   720
      Left            =   0
      TabIndex        =   5
      Top             =   0
      Width           =   6675
      _ExtentX        =   11774
      _ExtentY        =   1270
   End
   Begin VB.Label lbl_role 
      Caption         =   "#Action in this project"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   120
      TabIndex        =   8
      Tag             =   "lbl_role"
      Top             =   1860
      Width           =   2055
   End
   Begin VB.Label lbl_CCU 
      Caption         =   "#Customer"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   120
      TabIndex        =   7
      Tag             =   "lbl_CCU"
      Top             =   1365
      Width           =   2055
   End
   Begin VB.Label lbl_SP 
      Caption         =   "#Project"
      BeginProperty Font 
         Name            =   "MS Sans Serif"
         Size            =   8.25
         Charset         =   0
         Weight          =   700
         Underline       =   0   'False
         Italic          =   0   'False
         Strikethrough   =   0   'False
      EndProperty
      Height          =   255
      Left            =   120
      TabIndex        =   6
      Tag             =   "lbl_SP"
      Top             =   900
      Width           =   2055
   End
End
Attribute VB_Name = "LinkForm"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
Option Explicit

'******** INTERFACE
Private m_Language As String
Private ms_SQLActionType As String

'******** Connection Cursor
Private mo_ArmDb As Object
Private mb_Created As Boolean
Private mb_use_framework_connection As Boolean
Private ms_ConnectString As String
Private ms_UID As String
Public mt_CstValues As Type_CstValues          ' Structure which contains constants value

'******** Stored Procedures
Private ms_FILL_ProcStoc As String
Private ms_INS_ProcStoc As String
Private ms_UPD_ProcStoc As String
Private ms_DEL_ProcStoc As String
' task t298.13-A begin
Private ms_DEL2_ProcStoc As String      ' part 2 after successull test
' task t298.13-A end
Private ms_cbo_ProcStoc As String

'********
Private ms_SP_CapKey As String
Private ms_SP_desc As String

Private ms_CCU_CapKey As String
Private ms_CCU_desc As String

Private ms_CNT_Code As String

Private ms_CPR_Code As String
Private ms_CPR_Desc As String

Private mb_AlreadyOneSpecifier

Private mi_concurrency As Integer

Private mb_AlreadyLoaded As Boolean

Private mb_DataUpdated As Boolean

Private ms_defaultCountry  As String        ' 02/12/2013 JN Default country

'****** mw 26.8.2008 >>
Private mb_RP_Customer_Select As Boolean
Private ms_RP_Code As String
Private ms_RP_Desc As String

Public Sub ActivateRPCustomerSelection(ByVal as_RP_Code As String, ByVal as_RP_Desc As String, ByVal as_CCU_CapKey As String, ByVal as_CCU_Desc As String, ByVal as_CPR_Code As String, ByVal as_CPR_Desc As String)
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "LinkForm:ActivateRPCustomerSelection"
    #End If
    CapMouseOff
    
    mb_RP_Customer_Select = True
    ms_SP_CapKey = as_RP_Code
    ms_SP_desc = as_RP_Desc
    
    ms_CCU_CapKey = as_CCU_CapKey
    ms_CCU_desc = as_CCU_Desc
    
    ms_CPR_Code = as_CPR_Code
    ms_CPR_Desc = as_CPR_Desc
    
    seek_Proj.Enabled = False
    lbl_SP.Enabled = False
    
    CapMouseOn
End Sub

Public Property Get CCU_CapKey() As String
    CCU_CapKey = ms_CCU_CapKey
End Property

'mw <<

Public Property Get DataUpdated() As Boolean
    DataUpdated = mb_DataUpdated
End Property

Public Property Set ArmDb(ByRef ao_local_connection As Object)

    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "LinkForm:ArmDb_Set"
    #End If
    CapMouseOff
    
    If Not (ao_local_connection Is Nothing) Then
        Set mo_ArmDb = ao_local_connection
        mb_use_framework_connection = True

        Set tb_top.ArmDb = mo_ArmDb
        Set seek_Proj.ArmDb = mo_ArmDb
        Set seek_Cust.ArmDb = mo_ArmDb
        Set ckv_contact.ArmDb = mo_ArmDb
        Set cbo_role.ArmDb = mo_ArmDb
    End If
        
Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "LinkForm:ArmDb_Set"
    #End If
    CapMouseOn
End Property

Public Property Let ConnectString(as_ConnectString As String)

    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "LinkForm:ConnectString_Let", "as_ConnectString=" & as_ConnectString
    #End If
    CapMouseOff
    
    ms_UID = ConnectionStringValidation(as_ConnectString)
    If ms_UID = "" Then GoTo Trace_End
    
    ms_ConnectString = as_ConnectString
    
    tb_top.ConnectString = ms_ConnectString
    seek_Proj.ConnectString = ms_ConnectString
    seek_Cust.ConnectString = ms_ConnectString
    ckv_contact.ConnectString = ms_ConnectString
    cbo_role.ConnectString = ms_ConnectString
    
Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "LinkForm:ConnectString_Let"
    #End If
    CapMouseOn
End Property

Public Property Let Language(as_Language As String)
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "LinkForm:Language_Let", "as_Language=" & as_Language
    #End If
    CapMouseOff
    
    m_Language = as_Language
    tb_top.Language = m_Language
    seek_Proj.Language = m_Language
    seek_Cust.Language = m_Language
    ckv_contact.Language = m_Language
    
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "LinkForm:Language_Let"
    #End If
    CapMouseOn
End Property

Public Property Let SQLActionType(as_SQLActionType As String)
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "LinkForm:SQLActionType_Let", "as_SQLActionType=" & as_SQLActionType
    #End If
    CapMouseOff
    
    ms_SQLActionType = as_SQLActionType
    
    'set the fields enable or not in function of the choose mode
    If UCase$(ms_SQLActionType) = "DELETE" Then
        ControlsEnable Me.Controls, Me, False
    End If
        
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "LinkForm:SQLActionType_Let"
    #End If
    CapMouseOn
End Property

Public Property Get DefaultCountry() As String
    DefaultCountry = ms_defaultCountry
End Property

Public Property Let DefaultCountry(ByVal as_defaultCountry As String)
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "LinkForm:DefaultCountry_Let", "as_defaultCountry =" & as_defaultCountry
    #End If
    ms_defaultCountry = as_defaultCountry
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "LinkForm:DefaultCountry_Let"
    #End If
End Property

Public Property Let project(as_SP_Capkey As String)
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "LinkForm:Project_Let", "as_SP_CapKey=" & as_SP_Capkey
    #End If
    CapMouseOff
    
    ms_SP_CapKey = as_SP_Capkey
    
    If ms_SP_CapKey <> "" Then
        seek_Proj.Enabled = False
        lbl_SP.Enabled = False
    End If
    
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "LinkForm:Project_Let"
    #End If
    CapMouseOn
End Property

Public Property Let Customer(as_CCU_CapKey As String)
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "LinkForm:Customer_Let", "as_CCU_CapKey=" & as_CCU_CapKey
    #End If
    CapMouseOff
    
    ms_CCU_CapKey = as_CCU_CapKey
    
    If ms_CCU_CapKey <> "" Then
        seek_Cust.Enabled = False
        lbl_CCU.Enabled = False
    End If
    
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "LinkForm:Customer_Let"
    #End If
    CapMouseOn
End Property


Public Property Let contact(as_CNT_Code As String)
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "LinkForm:Contact_Let", "as_CNT_Code=" & as_CNT_Code
    #End If
    CapMouseOff
    
    ms_CNT_Code = as_CNT_Code
    
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "LinkForm:Contact_Let"
    #End If
    CapMouseOn
End Property


'Initialization of the component
Public Sub Load_A_Com()

    On Error GoTo Trace_Err
    CapMouseOff
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "LinkForm:Load_A_Com"
    #End If
    
    VerifyInitialization mo_ArmDb, ms_ConnectString, m_Language, Me
    
    'Variables of the module (can be use later in this method)
    ms_FILL_ProcStoc = "exec Cap_ProjectLink_sel '$SP$', '$CCU$', '$lang$'"
    ms_INS_ProcStoc = "exec Cap_ProjectLink_ins $SP$, $CCU$, $CPR$, '', '', null, '$spare1$', '$spare2$', $spare3$, $spare4$"
    ms_UPD_ProcStoc = "exec Cap_ProjectLink_upd $SP$, $CCU$, $iConc$, $CPR$, '', '', null, '$spare1$', '$spare2$', $spare3$, $spare4$"
    ms_DEL_ProcStoc = "exec Cap_ProjectLink_del $SP$, $CCU$"
' task t298.13-A begin
    ms_DEL2_ProcStoc = "exec Cap_ProjectLink_del2 $SP$, $CCU$"
' task t298.13-A end
    
    ms_cbo_ProcStoc = "exec Cap_ProjectCompanyRole_cbo '" & m_Language & "'"

    ckv_contact.Load_A_Com
    tb_top.Load_A_Com
    seek_Cust.Load_A_Com
    seek_Proj.Load_A_Com
    cbo_role.Load_A_Com
    
    'Initialization of the component of the form
    tb_top.ClearAllIcons
    tb_top.PictureDisplayed = "P_Valid=1 P_Undo=2 P_Quit=-1"
    
    cbo_role.FirstBlankItem = False
    cbo_role.SearchPrefix = " "
    cbo_role.Request = ms_cbo_ProcStoc

    seek_Proj.ComponentType = "PROJECT"
    seek_Cust.ComponentType = "CUSTOMER"
    
    seek_Cust.DefaultCountry = ms_defaultCountry
    seek_Proj.DefaultCountry = ms_defaultCountry
    
    If Not ASC_ConnectToDB(mo_ArmDb, ms_ConnectString, mb_Created) Then GoTo Trace_End
    
    'Initialize the screen constant of the form
    LoadLabels mo_ArmDb, Me.Controls, "Cap_Project_Link", m_Language
    
    'The data are not loaded
    mb_AlreadyLoaded = False
    
    'fill the textbox if needed
    InitFields

    Call DisplayExtendedControls
    
Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "LinkForm:Load_A_Com"
    #End If
    CapMouseOn
    Exit Sub
    
Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "LinkForm:Load_A_Com"
    CapMouseOn
End Sub

Private Sub cbo_role_ComboItemSelected()
    
    On Error GoTo Trace_Err
    CapMouseOff
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "LinkForm:cbo_role_ComboItemSelected"
    #End If
    
    If mb_AlreadyOneSpecifier And (GetCodeFromCombo(cbo_role) = mt_CstValues.CPR_Specifier) Then
        Call ASC_SendMessage(mo_ArmDb, m_Language, 850, "#Already a specifier", "")
        Set cbo_role.SelectedItem = Nothing
    End If
    Call DisplayExtendedControls
    
Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "LinkForm:cbo_role_ComboItemSelected"
    #End If
    CapMouseOn
    Exit Sub
    
Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "LinkForm:cbo_role_ComboItemSelected"
    CapMouseOn

    
End Sub





Private Sub Form_Load()
    ms_defaultCountry = gs_CaptureCountry
End Sub

'Event on the toolbar component
Private Sub tb_top_Action(ByVal as_SQLActionType As String)
    
    On Error GoTo Trace_Err
    CapMouseOff
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "LinkForm:tb_top_Action", "as_SQLActionType=" & as_SQLActionType
    #End If
    
    Select Case UCase$(as_SQLActionType)
    Case "VALID"
        'The user valid a change on the data
        '26.8.2008 mw - do not save anything if this form is called from SfbRefPro, used just for selection
        If mb_RP_Customer_Select = True Then
            mb_DataUpdated = True
            Me.Hide
        Else
            If SaveChanges Then
                'The save was OK. The datas have changed
                mb_DataUpdated = True
                Me.Hide
            End If
        End If
        
    Case "UNDO"
        'The user cancel all the changes but stay in this form
        InitFields
        
    Case "QUIT"
        'The user cancel all the changes and quit the form
        'The datas have not changed
        mb_DataUpdated = False
        Me.Hide
        
    End Select
    
Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "LinkForm:tb_top_Action"
    #End If
    CapMouseOn
    Exit Sub
    
Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "LinkForm:tb_top_Action"
    CapMouseOn
End Sub

Public Sub Unload_A_Com()
    
    On Error GoTo Trace_Err
    CapMouseOff
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "LinkForm:Unload_A_COM"
    #End If
    
    'Terminate the component
    tb_top.Unload_A_Com
    ckv_contact.Unload_A_Com
    seek_Cust.Unload_A_Com
    seek_Proj.Unload_A_Com
    cbo_role.Unload_A_Com
    
    'Disconnect from the database if this module has created the connection
    ASC_DisconnectFromDB mo_ArmDb, ms_UID, mb_Created
    
Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "LinkForm:Unload_A_COM"
    #End If
    CapMouseOn
    Exit Sub
    
Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "LinkForm:Unload_A_COM"
    CapMouseOn
End Sub

Private Sub seek_Proj_Change()
    On Error GoTo Trace_Err
    CapMouseOff
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "LinkForm:seek_Proj_Change"
    #End If
        
    ms_SP_CapKey = seek_Proj.SelectedItemCode
    ms_SP_desc = seek_Proj.SelectedItemDesc
    
    mb_AlreadyOneSpecifier = IsProjectHaveSpecifier
    
    reinitCkvContact

    Call DisplayExtendedControls

Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "LinkForm:seek_Proj_Change"
    #End If
    CapMouseOn
    Exit Sub
    
Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "LinkForm:seek_Proj_Change"
    CapMouseOn
End Sub

Private Sub seek_Cust_Change()
    On Error GoTo Trace_Err
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "LinkForm:seek_Cust_Change"
    #End If
    CapMouseOff
    
    ms_CCU_CapKey = seek_Cust.SelectedItemCode
    ms_CCU_desc = seek_Cust.SelectedItemDesc
    
    Call DisplayExtendedControls
    
    reinitCkvContact

Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "LinkForm:seek_Cust_Change"
    #End If
    CapMouseOn
    Exit Sub
    
Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "LinkForm:seek_Cust_Change"
    CapMouseOn
End Sub
    
Private Sub InitFields()
Dim ll_Cursor As Long
Dim ls_Request As String
    
    On Error GoTo Trace_Err
    CapMouseOff
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "LinkForm:InitFields"
    #End If
    
    If mb_AlreadyLoaded = False Then
    
        'Check the connection
        If Not ASC_ConnectToDB(mo_ArmDb, ms_ConnectString, mb_Created) Then GoTo Trace_End
    
        If mb_RP_Customer_Select = True Then ' mw 26.8.2008
                    
            mb_AlreadyOneSpecifier = False
            
        Else
            
            'Construct the request
            ls_Request = Replace(ms_FILL_ProcStoc, "$SP$", ms_SP_CapKey)
            ls_Request = Replace(ls_Request, "$CCU$", ms_CCU_CapKey)
            ls_Request = Replace(ls_Request, "$lang$", m_Language)
    
            'Execute the request
            ll_Cursor = mo_ArmDb.OpenSQL(ls_Request, -1)
            If ll_Cursor = 0 Then
                If Not go_Trace Is Nothing Then go_Trace.WriteTraceSQLError mo_ArmDb, "LinkForm:InitFields", "ls_Request=" & ls_Request
                GoTo Trace_End
            End If
            
            ms_SP_CapKey = mo_ArmDb.GetFields(ll_Cursor, "SP_CapKey")
            ms_SP_desc = mo_ArmDb.GetFields(ll_Cursor, "SP_desc")
            ms_CCU_CapKey = mo_ArmDb.GetFields(ll_Cursor, "CCU_CapKey")
            ms_CCU_desc = mo_ArmDb.GetFields(ll_Cursor, "CCU_desc")
            mi_concurrency = mo_ArmDb.GetFields(ll_Cursor, "iConcurrency")
            ms_CPR_Code = mo_ArmDb.GetFields(ll_Cursor, "CPR_Code")
            ms_CPR_Desc = mo_ArmDb.GetFields(ll_Cursor, "CPR_desc")
            
            mb_AlreadyOneSpecifier = IsProjectHaveSpecifier
        End If
        
    End If
    
    If ms_SP_CapKey = "" Then
        seek_Proj.Clear
    Else
        seek_Proj.LetSelectedItem ms_SP_CapKey, ms_SP_desc
    End If
    If ms_CCU_CapKey = "" Then
        seek_Cust.Clear
    Else
        seek_Cust.LetSelectedItem ms_CCU_CapKey, ms_CCU_desc
    End If
    
    cbo_role.Clear
    If ms_CPR_Code <> "0" And ms_CPR_Code <> "" Then
        Set cbo_role.SelectedItem = cbo_role.AddItem(Array(ms_CPR_Code, ms_CPR_Desc), True)
    End If
    
    reinitCkvContact
    
    mb_AlreadyLoaded = True
    
Trace_End:
    mo_ArmDb.Close ll_Cursor
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "LinkForm:InitFields"
    #End If
    CapMouseOn
    Exit Sub
    
Trace_Err:
    mo_ArmDb.Close ll_Cursor
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "LinkForm:InitFields"
    CapMouseOn
End Sub

Private Function SaveChanges() As Boolean
    
    On Error GoTo Trace_Err
    CapMouseOff
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "LinkForm:SaveChanges"
    #End If
    
    SaveChanges = True
    
    Select Case UCase$(ms_SQLActionType)
    Case "ADD"
        If Not RecordAdd Then
            SaveChanges = False
            GoTo Trace_End
        End If
    Case "UPDATE"
        If Not RecordUpdate Then
            SaveChanges = False
            GoTo Trace_End
        End If
        
    Case "DELETE"
        If Not RecordDelete Then
            SaveChanges = False
            GoTo Trace_End
        End If
    End Select
    
Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "LinkForm:SaveChanges", "Result=" & SaveChanges
    #End If
    CapMouseOn
    Exit Function
    
Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "LinkForm:SaveChanges"
    CapMouseOn
End Function

Private Function ReplaceInString(ByVal as_searchproc As String) As String
Dim ls_string As String
    
    On Error GoTo Trace_Err
    CapMouseOff
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "LinkForm:ReplaceInString", "as_searchproc=" & as_searchproc
    #End If
    
    ErrorOFF
    
    'replace the $$ in the query
    as_searchproc = Replace(as_searchproc, "$SP$", CorrectCboPrd(mo_ArmDb, m_Language, seek_Proj, True))
    as_searchproc = Replace(as_searchproc, "$CCU$", CorrectCboPrd(mo_ArmDb, m_Language, seek_Cust, True))
    as_searchproc = Replace(as_searchproc, "$CPR$", CorrectCodeStr(mo_ArmDb, m_Language, cbo_role, True))
    as_searchproc = Replace(as_searchproc, "$lang$", m_Language)
    as_searchproc = Replace(as_searchproc, "$spare1$", "")
    as_searchproc = Replace(as_searchproc, "$spare2$", "")
    as_searchproc = Replace(as_searchproc, "$spare3$", "0")
    as_searchproc = Replace(as_searchproc, "$spare4$", "0")
    as_searchproc = Replace(as_searchproc, "$iConc$", mi_concurrency)
    
    ReplaceInString = as_searchproc
    
Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "LinkForm:ReplaceInString", "Result=" & ReplaceInString
    #End If
    CapMouseOn
    Exit Function
    
Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "LinkForm:ReplaceInString"
    CapMouseOn
End Function


Private Sub reinitCkvContact()
    
    On Error GoTo Trace_Err
    CapMouseOff
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "LinkForm:reinitCkvContact"
    #End If
    
    If seek_Cust.SelectedItemCode <> "" And seek_Proj.SelectedItemCode <> "" Then
        'fill ckv_Contact
        ckv_contact.Clear
        ckv_contact.EditRequest = "exec Cap_Contact_lst2 '" & seek_Proj.SelectedItemCode & "', $0$"
        ckv_contact.CheckRequest = "exec Cap_ProjectContactLink_ins '" & seek_Proj.SelectedItemCode & "', $0$ , $1$ "
        ckv_contact.UnCheckRequest = "exec Cap_ProjectContactLink_del '" & seek_Proj.SelectedItemCode & "', $0$ , $1$ "
        ckv_contact.MasterID = seek_Cust.SelectedItemCode
        ckv_contact.Mode = ListLoadMode.ModeEdit
        ckv_contact.Columns = 3
        ckv_contact.HeaderSizes = Array(2000, 0, 0)
        

        ckv_contact.LoadList
        
        Dim ll_Count As Long, ll_Idx As Long
        ll_Count = ckv_contact.ListItems.Count
        
        For ll_Idx = 1 To ll_Count
            If (ckv_contact.ListItems.Item(ll_Idx).Tag.ID = ms_CNT_Code) Then
                ckv_contact.ListItems.Item(ll_Idx).Tag.DataChanged = True
                ckv_contact.ListItems.Item(ll_Idx).Tag.ReadOnly = True
                ckv_contact.ListItems.Item(ll_Idx).Tag.Checked = True
            End If
            If (ckv_contact.ListItems.Item(ll_Idx).Tag.GetData(1) = "X") Then
                ckv_contact.ListItems.Item(ll_Idx).Tag.ReadOnly = True
            End If
        Next
       ckv_contact.Display
        
    Else
        'empty ckv_Contact
        ckv_contact.Clear
    End If
    
Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "LinkForm:reinitCkvContact"
    #End If
    CapMouseOn
    Exit Sub
    
Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "LinkForm:reinitCkvContact"
    CapMouseOn
End Sub

Function RecordAdd() As Boolean
Dim ls_Request As String
Dim lb_Result As Boolean
Dim ls_Result As String

    On Error GoTo Trace_Err
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "LinkForm:RecordAdd"
    #End If
    CapMouseOff
    
    RecordAdd = False
    
    ls_Request = ReplaceInString(ms_INS_ProcStoc)
    
    ' Execution
    If ErrorFound Then GoTo Trace_End
        
    If Not ASC_ConnectToDB(mo_ArmDb, ms_ConnectString, mb_Created) Then GoTo Trace_End

    ASC_BeginTransaction mo_ArmDb

    lb_Result = ASC_RecordExec(mo_ArmDb, ls_Request, ls_Result)
    If lb_Result Then lb_Result = Check_ProjectRep
    If lb_Result Then lb_Result = ckv_contact.SaveList
    
    If lb_Result = False Then
        ASC_RollBackTransaction mo_ArmDb
        Call ASC_SendMessage(mo_ArmDb, m_Language, 891, "#An error occured during this manipulation, please contact your IT support")
        GoTo Trace_End
    End If
    
    ASC_CommitTransaction mo_ArmDb
    RecordAdd = True
    
Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "LinkForm:RecordAdd", "Result=" & RecordAdd
    #End If
    CapMouseOn
    Exit Function
    
Trace_Err:
    ASC_RollBackTransaction mo_ArmDb
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "LinkForm:RecordAdd"
    CapMouseOn
End Function

Private Function ControlInput() As Boolean

    On Error GoTo Trace_Err
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "LinkForm:ControlInput"
    #End If
    CapMouseOff
    
    ControlInput = False
    
    If seek_Proj.SelectedItemCode = "" Then
        Call ASC_SendMessage(mo_ArmDb, m_Language, 266, "#Missing Data in compulsory field")
        ErrorON
        seek_Proj.SetFocus
        GoTo Trace_End
    End If
    
    If GetTextFromCombo(cbo_role) = "" Then
        Call ASC_SendMessage(mo_ArmDb, m_Language, 266, "#Missing Data in compulsory field")
        ErrorON
        cbo_role.SetFocus
        GoTo Trace_End
    End If
    
    ControlInput = True

Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "LinkForm:ControlInput", "Result=" & ControlInput
    #End If
    CapMouseOn
    Exit Function
    
Trace_Err:
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "LinkForm:ControlInput"
    CapMouseOn
End Function

Private Function IsProjectContactSPALink(ByVal as_SP_Capkey As String)
Dim ll_Idx As Long
Dim ls_ResultCode As String

    IsProjectContactSPALink = False
    For ll_Idx = 1 To ckv_contact.Count
        If (ckv_contact.ListItems(ll_Idx).Tag.Checked = True) And _
           (ckv_contact.ListItems(ll_Idx).Tag.Checked <> ckv_contact.ListItems(ll_Idx).Checked) Then
            If ASC_RecordExec(mo_ArmDb, "exec SPA_Prj_Cust_Cnt_chk '" & as_SP_Capkey & "', NULL, '" & ckv_contact.ListItems(ll_Idx).Tag.ID & "'", ls_ResultCode) Then
                IsProjectContactSPALink = True
                Exit Function
            End If
        End If
    Next
    
End Function

Function RecordUpdate() As Boolean
Dim ls_Request As String
Dim lb_Result As Boolean
Dim ls_Result As String

    On Error GoTo Trace_Err
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "LinkForm:RecordUpdate"
    #End If
    CapMouseOff
    
    RecordUpdate = False
    
    ls_Request = ReplaceInString(ms_UPD_ProcStoc)
    
    'Execution
    If ErrorFound Then GoTo Trace_End
    
    If Not ASC_ConnectToDB(mo_ArmDb, ms_ConnectString, mb_Created) Then GoTo Trace_End

    If IsProjectContactSPALink(ms_SP_CapKey) Then
        Call ASC_SendMessage(mo_ArmDb, m_Language, 8721, "#You cannot delete this link because one or more SPA exists for this project and this contact !")
        GoTo Trace_End
    End If

    ASC_BeginTransaction mo_ArmDb

    lb_Result = True
    If ms_CPR_Code = mt_CstValues.CPR_Specifier And ms_CPR_Code <> GetCodeFromCombo(cbo_role) Then
        lb_Result = DeleteSpecRep
    End If
    If lb_Result Then lb_Result = ASC_RecordExec(mo_ArmDb, ls_Request, ls_Result)
    If lb_Result Then lb_Result = Check_ProjectRep
    If lb_Result Then lb_Result = ckv_contact.SaveList
    
    If lb_Result = False Then
        ASC_RollBackTransaction mo_ArmDb
        Call ASC_SendMessage(mo_ArmDb, m_Language, 891, "#An error occured during this manipulation, please contact your IT support")
        GoTo Trace_End
    End If
    
    ASC_CommitTransaction mo_ArmDb
    
    RecordUpdate = True
    
Trace_End:
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "LinkForm:RecordUpdate", "Result=" & RecordUpdate
    #End If
    CapMouseOn
    Exit Function
    
Trace_Err:
    ASC_RollBackTransaction mo_ArmDb
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "LinkForm:RecordUpdate"
    CapMouseOn
End Function

Function RecordDelete() As Boolean
Dim ll_Cursor As Long
Dim ls_Request As String
Dim lb_Result As Boolean
Dim ls_Result As String

    On Error GoTo Trace_Err
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "LinkForm:RecordDelete"
    #End If
    CapMouseOff
    
    RecordDelete = False
    
    ls_Request = "Exec Cap_ProjectLink_chk "
    ls_Request = ls_Request & "  '" & ms_SP_CapKey & "',"  '@SP_CapKey char (16)
    ls_Request = ls_Request & "  '" & ms_CCU_CapKey & "'"  '@CCU_CapKey char (16)
    
    If Not ASC_ConnectToDB(mo_ArmDb, ms_ConnectString, mb_Created) Then GoTo Trace_End
    
    ll_Cursor = mo_ArmDb.OpenSQL(ls_Request)
    If ll_Cursor = 0 Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceSQLError mo_ArmDb, "capprj:RecordDelete", "Request=" & ls_Request
        GoTo Trace_End
    End If
    If mo_ArmDb.GetFields(ll_Cursor, "ActionCount") <> "0" Then
        Call ASC_SendMessage(mo_ArmDb, m_Language, 247, "#You cannot delete this link because one or more action exists for this project and this company !")
        GoTo Trace_End
    End If
    If mo_ArmDb.GetFields(ll_Cursor, "MemoCount") <> "0" Then
        Call ASC_SendMessage(mo_ArmDb, m_Language, 246, "#You cannot delete this link because one or more memo exists for this project and this company !")
        GoTo Trace_End
    End If
    If mo_ArmDb.GetFields(ll_Cursor, "SPACount") <> "0" Then
        Call ASC_SendMessage(mo_ArmDb, m_Language, 8720, "#You cannot delete this link because one or more SPA exists for this project and this company !")
        GoTo Trace_End
    End If
    If mo_ArmDb.GetFields(ll_Cursor, "QuoteCount") <> "0" Then
        Call ASC_SendMessage(mo_ArmDb, m_Language, 2437, "#You cannot delete this link because one or more Quotes exists for this project and this company !")
        GoTo Trace_End
    End If

' task t298.13-A begin
    Dim ll_salesRepCount As Long
    Dim ls_repNames As String
    ll_salesRepCount = 0
    ls_repNames = ""
    While Not mo_ArmDb.EOF(ll_Cursor)
        ll_salesRepCount = ll_salesRepCount + mo_ArmDb.GetFields(ll_Cursor, "SalesRepCount")
        ls_repNames = IIf(ls_repNames = "", "", ls_repNames & ", ") & mo_ArmDb.GetFields(ll_Cursor, "SR_name")
        Call mo_ArmDb.Next(ll_Cursor)
    Wend
    mo_ArmDb.Close ll_Cursor
    
    'Execution
    If ErrorFound Then GoTo Trace_End

    If DeleteConfirmation(mo_ArmDb, m_Language) = False Then GoTo Trace_End

    Dim lb_deleteRep As Boolean
    If ll_salesRepCount = 0 Then
        Dim ls_Msg As String
        ls_Msg = Replace(ASC_MsgText(mo_ArmDb, m_Language, 283, "#The reps $NAME$ seems to be not involved anymore on this project as there is no company from him linked to the project." & vbCrLf & " Would you like to remove him from the project ?"), "$NAME$", ls_repNames)
        lb_deleteRep = (MsgBox(ls_Msg, vbYesNo, "Capture Online") = vbYes)
    Else
        ' some other company with the same sales rep included in project
        lb_deleteRep = False
    End If

    ' now we can start transaction
    ASC_BeginTransaction mo_ArmDb
        
    ls_Request = ReplaceInString(ms_DEL_ProcStoc)
    lb_Result = ASC_RecordExec(mo_ArmDb, ls_Request, ls_Result)
    If lb_Result = False Then
        ASC_RollBackTransaction mo_ArmDb
        Call ASC_SendMessage(mo_ArmDb, m_Language, 891, "#An error occured during this manipulation, please contact your IT support")
        GoTo Trace_End
    End If
        
    ' delete rep, if it was confirmed by user
    If lb_deleteRep Then
        ls_Request = ReplaceInString(ms_DEL2_ProcStoc)
        lb_Result = ASC_RecordExec(mo_ArmDb, ls_Request, ls_Result)
        If lb_Result = False Then
            ASC_RollBackTransaction mo_ArmDb
            Call ASC_SendMessage(mo_ArmDb, m_Language, 891, "#An error occured during this manipulation, please contact your IT support")
            GoTo Trace_End
        End If
    End If
' task t298.13-A end
    

    ASC_CommitTransaction mo_ArmDb
    RecordDelete = True
    
Trace_End:
    mo_ArmDb.Close ll_Cursor
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "LinkForm:RecordDelete", "Result=" & RecordDelete
    #End If
    CapMouseOn
    Exit Function
    
Trace_Err:
    mo_ArmDb.Close ll_Cursor
    ASC_RollBackTransaction mo_ArmDb
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "LinkForm:RecordDelete"
    CapMouseOn
End Function

' COPY FROM Tools module
' Get an error message
Private Function ASC_MsgText(ByRef ao_Armdb As Object, ByVal as_LG_Code As String, ByVal ai_MsgID As Integer, Optional ByVal as_MsgDefault As String = "")
Dim lc_Msg As Long
Dim ls_Msg As String, ls_Request As String

    On Error GoTo Trace_Err
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "Tools:ASC_MsgText", "LG_Code=" & as_LG_Code & ", ai_MsgID=" & ai_MsgID & ", as_MsgDefault=" & as_MsgDefault
    #End If
    CapMouseOff
    
    ls_Request = "SELECT Message_Text FROM Error_Message WHERE Language_Code = '" & as_LG_Code & "' AND MsgID = " & ai_MsgID
    lc_Msg = ao_Armdb.OpenSQL(ls_Request)
    If lc_Msg = 0 Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceSQLError ao_Armdb, "Tools:ASC_MsgText", "Request=" & ls_Request
        GoTo Trace_End
    End If
    
    ls_Msg = ao_Armdb.GetFields(lc_Msg, "MESSAGE_TEXT")
    
Trace_End:
    Call ao_Armdb.Close(lc_Msg)
    ASC_MsgText = IIf(Len(ls_Msg) <> 0, ls_Msg, as_MsgDefault)
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "Tools:ASC_MsgText", "Result=" & ASC_MsgText
    #End If
    CapMouseOn
    Exit Function
    
Trace_Err:
    ASC_MsgText = ""
    Call ao_Armdb.Close(lc_Msg)
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "Tools:ASC_MsgText"
    CapMouseOn
End Function



Private Sub DisplayExtendedControls()
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "LinkForm:DisplayExtendedControls"
    #End If
    CapMouseOff
    
    cbo_role.Visible = (ms_SP_CapKey <> "") And (ms_CCU_CapKey <> "")
    lbl_role.Visible = (ms_SP_CapKey <> "") And (ms_CCU_CapKey <> "")
        
    If mb_RP_Customer_Select = True Then ' mw 26.8.2008
        ' do not show contact if this form is called from SfbRefPro
        lbl_CNT.Visible = False
    Else
        lbl_CNT.Visible = (ms_SP_CapKey <> "") And (ms_CCU_CapKey <> "")
    End If
    
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "LinkForm:DisplayExtendedControls"
    #End If
    CapMouseOn
End Sub

Private Function Check_ProjectRep() As Boolean
Dim ls_SR_Code As String
Dim ls_SP_Capkey As String
Dim ls_SR_Name As String
Dim lb_AddAsCopied As Boolean
Dim ls_Change As Boolean
Dim ls_Result As String

Dim lc_Specifier As Long
Dim lc_Customer As Long
Dim lc_Master As Long
Dim ls_Request As String
Dim lc_CustomerReps As Long
Dim lc_ProjectReps As Long
Dim ls_CCU_Capkey As String
    
    On Error GoTo Trace_Err
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "LinkForm:Check_ProjectRep"
    #End If
    CapMouseOff
    
    Check_ProjectRep = False
    
    ' First, we search the guy
    ls_CCU_Capkey = seek_Cust.SelectedItemCode
    
    ' The guy is perhaps a specifier or a customer, we search in the both
    ls_Request = "exec Cap_CompanyRep_lst3 " & "'" & ls_CCU_Capkey & "','" & m_Language & "'"
    lc_CustomerReps = mo_ArmDb.OpenSQL(ls_Request)
    If lc_CustomerReps = 0 Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceSQLError mo_ArmDb, "LinkForm:Check_ProjectRep", "ls_Request= " & ls_Request
        GoTo Trace_End
    End If
        
    lc_Specifier = mo_ArmDb.Filter(lc_CustomerReps, "BU_GROUPING", "=", mt_CstValues.RRGRP_Spec, 1)
    lc_Customer = mo_ArmDb.Filter(lc_CustomerReps, "BU_GROUPING", "=", mt_CstValues.RRGRP_Cust, 1)
    
    lc_Master = mo_ArmDb.JoinOr(lc_Specifier, lc_Customer, True)

    ' THE Errors are checked in item_check
    ls_SR_Code = mo_ArmDb.GetFields(lc_Master, "SR_Code")
    ls_SR_Name = mo_ArmDb.GetFields(lc_Master, "SR_NAME")
    ls_SP_Capkey = seek_Proj.SelectedItemCode
    
    ls_Request = "Exec Cap_ProjectRep_Lst3 " & "'" & ls_SP_Capkey & "','" & m_Language & "'"
    lc_ProjectReps = mo_ArmDb.OpenSQL(ls_Request)
    If lc_ProjectReps = 0 Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceSQLError mo_ArmDb, "LinkForm:Check_ProjectRep", "ls_Request= " & ls_Request
        GoTo Trace_Err
    End If
    
    lb_AddAsCopied = CStr(GetCodeFromCombo(cbo_role)) <> CStr(mt_CstValues.CPR_Specifier)
    
    ' We check if we want to add the guy as copied
    If lb_AddAsCopied Then
        ' Is the guy already linked ?
        If mo_ArmDb.Find(lc_ProjectReps, "SR_Code", ls_SR_Code, , 1) > -1 Then
            ' Okay, we have nothing to do
        Else '
            ' No ? We add it !
            If Not Add_ProjectRep(mo_ArmDb, ls_SP_Capkey, ls_SR_Code, mt_CstValues.RR_Copied, ls_Result) Then GoTo Trace_Err
        End If
        ' And it's finish !
    Else
        ' Is the guy already linked ?
        If mo_ArmDb.Find(lc_ProjectReps, Array("SR_Code", "BU_GROUPING"), Array(ls_SR_Code, mt_CstValues.RRGRP_Spec)) < 0 Then
            If mo_ArmDb.Find(lc_ProjectReps, Array("SR_Code"), Array(ls_SR_Code)) > -1 Then
                
                Select Case CStr(mo_ArmDb.GetFields(lc_ProjectReps, "BU_GROUPING"))
                    Case CStr(mt_CstValues.RRGRP_Copied)
                        If Not Update_ProjectRep(mo_ArmDb, ls_SP_Capkey, ls_SR_Code, mo_ArmDb.GetFields(lc_ProjectReps, "RR_Code"), mt_CstValues.RR_Spec, ls_Result) Then GoTo Trace_Err
                    Case CStr(mt_CstValues.RRGRP_Spec)
                        ' NOTHING TO DO
                    Case Else
                        If Not Add_ProjectRep(mo_ArmDb, ls_SP_Capkey, ls_SR_Code, mt_CstValues.RR_Spec, ls_Result) Then GoTo Trace_Err
                End Select
    
            Else '
                ' Definitively, the guy must be added as the specifier !
                If Not Add_ProjectRep(mo_ArmDb, ls_SP_Capkey, ls_SR_Code, mt_CstValues.RR_Spec, ls_Result) Then GoTo Trace_Err
            End If
        End If
    End If
    
    Check_ProjectRep = True
    
Trace_End:
    Call mo_ArmDb.Close(lc_Master)
    Call mo_ArmDb.Close(lc_CustomerReps)
    Call mo_ArmDb.Close(lc_ProjectReps)
    Call mo_ArmDb.Close(lc_Specifier)
    Call mo_ArmDb.Close(lc_Customer)
    
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "LinkForm:Check_ProjectRep"
    #End If
    CapMouseOn
    Exit Function
    
Trace_Err:
    Call mo_ArmDb.Close(lc_Master)
    Call mo_ArmDb.Close(lc_CustomerReps)
    Call mo_ArmDb.Close(lc_ProjectReps)
    Call mo_ArmDb.Close(lc_Specifier)
    Call mo_ArmDb.Close(lc_Customer)
    
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "LinkForm:Check_ProjectRep"
    CapMouseOn
End Function

Private Function DeleteSpecRep() As Boolean
Dim ls_SP_Capkey As String
Dim ls_Request As String
Dim lc_ProjectReps As Long
Dim ls_Result As String
Dim ls_RepKey As String

    On Error GoTo Trace_Err
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "LinkForm:DeleteSpecRep"
    #End If
    CapMouseOff
    
    DeleteSpecRep = False
    
    ls_SP_Capkey = seek_Proj.SelectedItemCode
    ls_Request = "Exec Cap_ProjectRep_Lst3 " & "'" & ls_SP_Capkey & "','" & m_Language & "'"
    lc_ProjectReps = mo_ArmDb.OpenSQL(ls_Request)
    If lc_ProjectReps = 0 Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceSQLError mo_ArmDb, "LinkForm:Check_ProjectRep", "ls_Request= " & ls_Request
        GoTo Trace_End
    End If
    
    ' Is there a project spec rep to update
    If mo_ArmDb.Find(lc_ProjectReps, "BU_GROUPING", mt_CstValues.RRGRP_Spec, , 1) >= 0 Then
    
        '   Okay, we must update it
        'if the rep is already linked to the company as customer we delete
        ls_RepKey = mo_ArmDb.GetFields(lc_ProjectReps, "SR_CODE")
        If mo_ArmDb.Find(lc_ProjectReps, Array("BU_GROUPING", "SR_CODE"), Array(mt_CstValues.RRGRP_Spec, ls_RepKey), , 1) > -1 Then
            If Not Delete_ProjectRep(mo_ArmDb, ls_SP_Capkey, ls_RepKey, mo_ArmDb.GetFields(lc_ProjectReps, "RR_Code"), ls_Result) Then GoTo Trace_End
        Else
            If Not Update_ProjectRep(mo_ArmDb, ls_SP_Capkey, ls_RepKey, mo_ArmDb.GetFields(lc_ProjectReps, "RR_Code"), mt_CstValues.RR_Copied, ls_Result) Then GoTo Trace_End
        End If
    
    End If
    
    DeleteSpecRep = True
    
Trace_End:
    Call mo_ArmDb.Close(lc_ProjectReps)
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "LinkForm:Check_ProjectRep"
    #End If
    CapMouseOn
    Exit Function
    
Trace_Err:
    Call mo_ArmDb.Close(lc_ProjectReps)
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "LinkForm:Check_ProjectRep"
    CapMouseOn
End Function

Private Function IsProjectHaveSpecifier() As Boolean
Dim ls_Request As String
Dim ll_Cursor As Long

    On Error GoTo Trace_Err
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc True, "LinkForm:IsProjectHaveSpecifier"
    #End If
    CapMouseOff
    
    IsProjectHaveSpecifier = False
    
    If ms_SP_CapKey = "" Then GoTo Trace_End
    
    ls_Request = "SELECT TOP 1 CCU_Capkey FROM Cap_ProjectCompany WHERE SP_Capkey = " & FormatSqlStringParameter(ms_SP_CapKey) & " AND CPR_Code = " & mt_CstValues.CPR_Specifier
    
    ll_Cursor = mo_ArmDb.OpenSQL(ls_Request)
    If ll_Cursor = 0 Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceSQLError mo_ArmDb, "LinkForm:IsProjectHaveSpecifier", "Request=" & ls_Request
        GoTo Trace_End
    End If
    
    IsProjectHaveSpecifier = (mo_ArmDb.GetFields(ll_Cursor, 0) <> "")
    
Trace_End:
    Call mo_ArmDb.Close(ll_Cursor)
    #If CapDebug Then
        If Not go_Trace Is Nothing Then go_Trace.WriteTraceProc False, "LinkForm:IsProjectHaveSpecifier", "Result=" & IsProjectHaveSpecifier
    #End If
    CapMouseOn
    Exit Function
    
Trace_Err:
    Call mo_ArmDb.Close(ll_Cursor)
    If Not go_Trace Is Nothing Then go_Trace.WriteTraceError Err.Number, Err.Description, "LinkForm:IsProjectHaveSpecifier"
    CapMouseOn
End Function








